<?php

/**
 * (SN) PM Viewer
 * Message Logging Routines
 * Last Updated: May 15th 2011
 *
 * @author 		signet51
 * @copyright	(c) 2011 signet51 Modding
 * @version		1.6.3 (1630)
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class messageLogging
{
	/**
	 * Registry object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $registry;
	
	/**
	 * Database object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $DB;
	
	/**
	 * Settings object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $settings;
	
	/**
	 * Request object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $request;
	
	/**
	 * Language object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $lang;
	
	/**
	 * Member object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $member;
	
	/**
	 * Cache object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $cache;
	
	/**
	 * Constructor
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @return	void
	 */
	public function __construct( ipsRegistry $registry )
	{
		/* Make object */
		$this->registry = $registry;
		$this->DB       = $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->lang     = $this->registry->getClass('class_localization');
		$this->member   = $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache    = $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();
		
	}

	/**
	 * Log personal conversations
	 *
	 * @access	public
	 * @param	string			[string|array] - can also be system, hard, or ids, which are converted to the new formats if IPB version is 3.0, if running 3.1 it is assumed the misnamed things have been generated by un-needed file edits so we can ignore them
	 * @param	string			Conversation IDs
	 * @return	void			
	 *
	 */
	public function logTopics( $type='string', $ids )
	{
		if ( ! $this->settings['pmviewer_log_deleted'] AND ! $this->settings['pmviewer_deleted_log'] )
		{
			return false;
		}
		
		/* INIT */
		$dbpre    	= ips_DBRegistry::getPrefix();
		$_converted = 0;
		
		$version = IPSLib::fetchVersionNumber();

		if ( $version['long'] < 31000 )
		{
			if ( $type == 'system' OR $type == 'hard' )
			{
				$type = 'array';
			}
			elseif ( $type == 'ids' )
			{
				$type = 'string';
			}
		}
	
		if ( $type == 'array' )
		{
			if ( is_array( $ids ) )
			{
				$ids 		= implode( ',', array_keys( $ids ) );
				$_converted = 1;
			}
		}
		
		if ( $type == 'string' OR $_converted == 1 )
		{
			/* Steal the topics */
			ipsRegistry::DB()->allow_sub_select=1;
			$this->DB->query( "REPLACE INTO {$dbpre}pmviewer_message_topics
								SELECT * FROM {$dbpre}message_topics WHERE mt_id IN (". $ids . ")" );
								
			/* Steal the posts */
			ipsRegistry::DB()->allow_sub_select=1;
			$this->DB->query( "REPLACE INTO {$dbpre}pmviewer_message_posts
								SELECT * FROM {$dbpre}message_posts WHERE msg_topic_id IN (". $ids . ")" );
			
			/* Steal the people */
			ipsRegistry::DB()->allow_sub_select=1;
			$this->DB->query( "REPLACE INTO {$dbpre}pmviewer_message_topic_user_map
								SELECT * FROM {$dbpre}message_topic_user_map WHERE map_topic_id IN (". $ids . ")" );
								
			$this->DB->update( 'pmviewer_message_topics', array( 'mt_to_count' => 0, 'mt_is_deleted' => 1 ), 'mt_id IN (' . $ids . ')' );
			$this->DB->update( 'pmviewer_message_topic_user_map', array( 'map_user_active' => 0 ), 'map_topic_id IN ('. $ids . ')' );
		}
		
		return true;
	}
	
	/**
	 * Log messages in a conversation
	 *
	 * @param	string			Message IDs
	 * @access	public
	 *
	 */
	public function logMessages( $msgIDs )
	{
		if ( ! $this->settings['pmviewer_log_deleted'] AND ! $this->settings['pmviewer_deleted_log'] )
		{
			return false;
		}
		
		/* INIT */
		$dbpre    = ips_DBRegistry::getPrefix();
		
		if ( is_array( $msgIDs ) )
		{
			$msgIDs = implode( ',', IPSLib::cleanIntArray( $msgIDs ) );
		}
		
		/* Simply move the posts and get out */
		ipsRegistry::DB()->allow_sub_select=1;
		$this->DB->query( "INSERT INTO {$dbpre}pmviewer_message_posts
							SELECT * FROM {$dbpre}message_posts WHERE msg_id IN (" . $msgIDs . ")" );
		
		return true;
	}
	
}